/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.export.csv;

import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnull;

public class CompatibilityReader
extends Reader {
    private final Reader reader;
    private final char escape;
    private final char quote;
    private boolean escaped;
    private int next;
    private boolean hasNext;

    public CompatibilityReader(Reader reader, char escape, char quote) {
        this.reader = reader;
        this.escape = escape;
        this.quote = quote;
        this.escaped = false;
        this.hasNext = false;
    }

    @Override
    public int read(@Nonnull char[] cbuf, int off, int len) throws IOException {
        int n = 0;
        while (n < len) {
            int read;
            if (!this.hasNext) {
                read = this.reader.read();
            } else {
                read = this.next;
                this.hasNext = false;
            }
            if (read == -1) {
                return n == 0 ? -1 : n;
            }
            char c = (char)read;
            if (this.escaped) {
                if (c == this.escape) {
                    cbuf[off + n] = this.escape;
                } else if (c == this.quote) {
                    cbuf[off + n] = this.quote;
                    this.next = this.quote;
                    this.hasNext = true;
                } else {
                    cbuf[off + n] = this.escape;
                    this.next = c;
                    this.hasNext = true;
                }
                ++n;
                this.escaped = false;
                continue;
            }
            if (c == this.escape) {
                this.escaped = true;
                continue;
            }
            cbuf[off + n] = c;
            ++n;
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

